/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.MainScreen;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public class ConfigData {
    private static final String sDefaultSDKLocation = "C:\\SDK";
    private static final String sDefaultVersion = "0.00";
    private static final String sConfigFile = "SDKConfig.xml";
    private static final String sDefaultFileEditor = "SDK Default Editor";
    private static final String sDefaultUserImageFileLocation = "C:\\SDK\\examples\\";
    private static final String sDefaultUserScriptFileLocation = "C:\\SDK\\scripts\\";
    private static final String sDefaultCompileTool = "objcompile.bat";
    private static final String[] sDefaultOutputTabs = new String[]{"Compile", "Connection", "Running"};
    private static final int sDefaultWindowWidth = 800;
    private static final int sDefaultWindowHeight = 600;
    private static final int sDefaultMaxEditorNum = 10;
    private static final String[] sDefaultAvailableFileEditor = new String[]{"SDK Default Editor", "NotePad", "", "", "", "", "", "", "", "Other..."};
    private static final String[] sDefaultAvailableFileExe = new String[]{"SDK Default Editor", "NotePad", "", "", "", "", "", "", "", "Other..."};
    public static String sSDKLocation = "C:\\SDK";
    public static String sVersion = "0.00";
    public static String sFileEditor = "SDK Default Editor";
    public static final String sCompilerRelevantDirectory = "\\compiler\\";
    public static final String sDocRelevantDirectory = "\\doc\\";
    public static final String sExampleRelevantDirectory = "\\examples\\";
    public static final String sIncludeRelevantDirectory = "\\include\\";
    public static final String sScriptRelevantDirectory = "\\scripts\\";
    public static final String sTemplateRelevantDirectory = "\\script_templates\\";
    public static String sCompilerAbsoluteDirectory = null;
    public static String sDocAbsoluteDirectory = null;
    public static String sExampleAbsoluteDirectory = null;
    public static String sIncludeAbsoluteDirectory = null;
    public static String sUserScriptFileAbsoluteLocation = null;
    public static String sUserImageFileAbsoluteLocation = null;
    public static String sScriptTemplateAbsoluteDirectory = null;
    public static String sCompileTool = "objcompile.bat";
    public static String[] sOutputTabs = sDefaultOutputTabs;
    public static int sWindowWidth = 800;
    public static int sWindowHeight = 600;
    public static int sMaxEditorNum = 10;
    public static String[] sAvailableFileEditor = sDefaultAvailableFileEditor;
    public static String[] sAvailableFileExe = sDefaultAvailableFileExe;
    public static final String defaultURL = "http://www.quantumdata.com/support/downloads/SDK/QDSDK_1.0/sdkrelease.php";
    public static final boolean testBypassDownload = false;
    public static final String testZipFilePath = "./downloads/Release_TEST.zip";
    private static final String sPropVersion = "Version";
    private static final String sPropFileEditor = "FileEditor";
    private static final String sPropWindowHeight = "WindowHeight";
    private static final String sPropWindowWidth = "WindowWidth";
    private static final String sPropUserImageFileLocation = "UserImageFileLocation";
    private static final String sPropUserScriptFileLocation = "UserScriptFileLocation";
    private static final String[] sPropAvailableFileEditor = new String[]{"AvailableFileEditors0", "AvailableFileEditors1", "AvailableFileEditors2", "AvailableFileEditors3", "AvailableFileEditors4", "AvailableFileEditors5", "AvailableFileEditors6", "AvailableFileEditors7", "AvailableFileEditors8", "AvailableFileEditors9"};
    private static final String[] sPropAvailableFileExe = new String[]{"AvailableFileEditorExes0", "AvailableFileEditorExes1", "AvailableFileEditorExes2", "AvailableFileEditorExes3", "AvailableFileEditorExes4", "AvailableFileEditorExes5", "AvailableFileEditorExes6", "AvailableFileEditorExes7", "AvailableFileEditorExes8", "AvailableFileEditorExes9"};

    private static Properties DefaultConfig() {
        Properties properties = new Properties();
        properties.setProperty(sPropVersion, sDefaultVersion);
        properties.setProperty(sPropFileEditor, sDefaultFileEditor);
        properties.setProperty(sPropUserImageFileLocation, sDefaultUserImageFileLocation);
        properties.setProperty(sPropUserScriptFileLocation, sDefaultUserScriptFileLocation);
        properties.setProperty(sPropWindowHeight, Integer.toString(600));
        properties.setProperty(sPropWindowWidth, Integer.toString(800));
        for (int i = 0; i < 10; ++i) {
            properties.setProperty(sPropAvailableFileEditor[i], sDefaultAvailableFileEditor[i]);
            properties.setProperty(sPropAvailableFileExe[i], sDefaultAvailableFileExe[i]);
        }
        return properties;
    }

    public static void LoadConfig() {
        Preferences preferences = Preferences.systemNodeForPackage(ConfigData.class);
        sSDKLocation = preferences.get("sdk_location", sDefaultSDKLocation);
        Properties properties = new Properties(ConfigData.DefaultConfig());
        try {
            FileInputStream fileInputStream = new FileInputStream(sSDKLocation + sDocRelevantDirectory + sConfigFile);
            properties.loadFromXML(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Config File Not Found... Loading Default Config");
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            System.err.println("Invalid Config File Format... Loading Default Config");
        }
        catch (IOException iOException) {
            System.err.println("IO Error... Loading Default Config");
        }
        sFileEditor = properties.getProperty(sPropFileEditor);
        sVersion = properties.getProperty(sPropVersion);
        sUserImageFileAbsoluteLocation = properties.getProperty(sPropUserImageFileLocation);
        sUserScriptFileAbsoluteLocation = properties.getProperty(sPropUserScriptFileLocation);
        sWindowWidth = Integer.valueOf(properties.getProperty(sPropWindowWidth));
        sWindowHeight = Integer.valueOf(properties.getProperty(sPropWindowHeight));
        sCompilerAbsoluteDirectory = sSDKLocation + sCompilerRelevantDirectory;
        sDocAbsoluteDirectory = sSDKLocation + sDocRelevantDirectory;
        sExampleAbsoluteDirectory = sSDKLocation + sExampleRelevantDirectory;
        sIncludeAbsoluteDirectory = sSDKLocation + sIncludeRelevantDirectory;
        sScriptTemplateAbsoluteDirectory = sSDKLocation + sTemplateRelevantDirectory;
        for (int i = 0; i < 10; ++i) {
            properties.setProperty(sAvailableFileEditor[i], sPropAvailableFileEditor[i]);
            properties.setProperty(sAvailableFileExe[i], sPropAvailableFileExe[i]);
        }
    }

    public static void StoreConfig() {
        Preferences preferences = Preferences.systemNodeForPackage(ConfigData.class);
        preferences.put("sdk_location", sSDKLocation);
        Properties properties = new Properties(ConfigData.DefaultConfig());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(sSDKLocation + sDocRelevantDirectory + sConfigFile);
            properties.setProperty(sPropFileEditor, sFileEditor);
            properties.setProperty(sPropVersion, sVersion);
            properties.setProperty(sPropUserImageFileLocation, sUserImageFileAbsoluteLocation);
            properties.setProperty(sPropUserScriptFileLocation, sUserScriptFileAbsoluteLocation);
            properties.setProperty(sPropWindowHeight, Integer.toString(sWindowHeight));
            properties.setProperty(sPropWindowWidth, Integer.toString(sWindowWidth));
            for (int i = 0; i < 10; ++i) {
                properties.setProperty(sPropAvailableFileEditor[i], sAvailableFileEditor[i]);
                properties.setProperty(sPropAvailableFileExe[i], sAvailableFileExe[i]);
            }
            properties.storeToXML((OutputStream)fileOutputStream, null, "UTF-8");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Config File Not Found...");
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            System.err.println("Invalid Config File Format... Loading Default Config");
            JOptionPane.showMessageDialog(null, "StoreConfig()", "InvalidPropertiesFormatException", 0);
        }
        catch (IOException iOException) {
            System.err.println("IO Error... ");
            JOptionPane.showMessageDialog(null, "StoreConfig()", "IOException", 0);
        }
    }

    private static void StoreSDKLocation() {
        Preferences preferences = Preferences.systemNodeForPackage(ConfigData.class);
        preferences.put("sdk_location", sSDKLocation);
    }

    public static void updateSDKPath(String string) {
        sSDKLocation = string;
        ConfigData.StoreSDKLocation();
        sCompilerAbsoluteDirectory = sSDKLocation + sCompilerRelevantDirectory;
        sDocAbsoluteDirectory = sSDKLocation + sDocRelevantDirectory;
        sExampleAbsoluteDirectory = sSDKLocation + sExampleRelevantDirectory;
        sIncludeAbsoluteDirectory = sSDKLocation + sIncludeRelevantDirectory;
        sScriptTemplateAbsoluteDirectory = sSDKLocation + sTemplateRelevantDirectory;
    }

    public static void updateUserFilePath(String string) {
        String string2 = string.substring(0, string.lastIndexOf("\\") + 1);
        if (MainScreen.isScriptSDK) {
            if (string2.contentEquals(sUserScriptFileAbsoluteLocation)) {
                return;
            }
            sUserScriptFileAbsoluteLocation = string2;
            ConfigData.StoreConfig();
        } else {
            if (string2.contentEquals(sUserImageFileAbsoluteLocation)) {
                return;
            }
            sUserImageFileAbsoluteLocation = string2;
            ConfigData.StoreConfig();
        }
    }

    public static String getFileName(File file) {
        return ConfigData.getName(file.getAbsolutePath());
    }

    public static String getName(String string) {
        int n = string.lastIndexOf(".");
        int n2 = string.lastIndexOf("\\");
        return string.substring(n2 + 1, n);
    }
}

